#include <stdio.h>
#include <winsock.h>
#include "Pagalba.h"

#define HOST_ADDR "127.0.0.1"     //127.0.0.1 - localhost IP adresas
#define PORTAS 5462

int main(int argc, char *argv[])
{
/****************************************************************/
/*	Winsock inicializacija                                      */
/****************************************************************/
    WORD wVersionRequested;
	WSADATA wsaData;
	wVersionRequested = MAKEWORD( 2, 2 );
	WSAStartup( wVersionRequested, &wsaData );

/****************************************************************/
/*	Gauname hosto adresa				 						*/
/****************************************************************/
	struct hostent *hp= gethostbyname(HOST_ADDR);
	if (hp == NULL){
		printf("Ivyko klaida randant host'o adresa: %i\n", WSAGetLastError());
		return -1;
	}

/****************************************************************/
/*	Sukuriame soketa					 						*/
/****************************************************************/
	SOCKET s= socket(hp->h_addrtype,SOCK_STREAM,0);
	if (s < 0){
		printf("Ivyko klaida kuriant soketa: %i\n", WSAGetLastError());
		return -1;
	}

/****************************************************************/
/*	Jungiames prie serverio				 						*/
/****************************************************************/
	struct sockaddr_in sa;
	memset(&sa, 0, sizeof(sa));
	memcpy((char *)&sa.sin_addr, hp->h_addr, hp->h_length);
	sa.sin_family= hp->h_addrtype;
	int portas= PORTAS;
	sa.sin_port= htons((u_short)portas);
	if (connect(s,(struct sockaddr *)&sa,sizeof sa) < 0)
	{
		closesocket(s);
		printf("Ivyko klaida jungiantis prie serverio: %i\n", WSAGetLastError());
		printf("\t(porto numeris - %i)\n", portas);
		return -1;
	}

/****************************************************************/
/*	Siunciame uzklausas serveriui		 						*/
/****************************************************************/
    char* pranesimas= "Labas!";
    SiustiStr(s, pranesimas, strlen(pranesimas)+1);     //Siunciame pasisveikinimo pranesima
    printf("Issiunciau pranesima: %s\n", pranesimas);

    int sk1= 15;
    SiustiSk(s, sk1);        //siunciame pirma parametra
    printf("Issiunciau skaiciu: %d\n", sk1);
    int sk2= 28;
    SiustiSk(s, sk2);        //siunciame antra parametra
    printf("Issiunciau skaiciu: %d\n", sk2);
    int rez= PriimtiSk(s);   //gauname rezultata
    printf("Gavau skaiciu: %d\n", rez);
    printf("Rezultatas: %d + %d = %d\n", sk1, sk2, rez);

/****************************************************************/
/*	Udaroms soketus                                            */
/****************************************************************/
    closesocket(s);
    WSACleanup();

    return 0;
}
